DROP TABLE VETCHOICE.AGGREGATE_H CASCADE CONSTRAINTS;

CREATE TABLE VETCHOICE.AGGREGATE_H
(
  PERID                 VARCHAR2(11 BYTE),
  ICN                   VARCHAR2(29 BYTE),
  EDIPI                 VARCHAR2(11 BYTE),
  SSN                   VARCHAR2(9 BYTE),
  LN                    VARCHAR2(35 BYTE),
  FN                    VARCHAR2(25 BYTE),
  MN                    VARCHAR2(25 BYTE),
  SUF                   VARCHAR2(10 BYTE),
  DOB                   VARCHAR2(8 BYTE),
  DOD                   VARCHAR2(14 BYTE),
  GENDER                VARCHAR2(1 BYTE),
  ENR_DTE               VARCHAR2(8 BYTE),
  CV_ELIG               VARCHAR2(8 BYTE),
  ELIG_VERIFIED         VARCHAR2(1 BYTE),
  ENR_CODE              VARCHAR2(2 BYTE),
  PRIORITY              VARCHAR2(2 BYTE),
  ENR_CRE_DTE           VARCHAR2(14 BYTE)       NOT NULL,
  ADD_TYPE              VARCHAR2(1 BYTE),
  BAI                   VARCHAR2(1 BYTE),
  ADDRESS_ID            VARCHAR2(11 BYTE),
  ST1                   VARCHAR2(70 BYTE),
  ST2                   VARCHAR2(70 BYTE),
  ST3                   VARCHAR2(70 BYTE),
  CITY                  VARCHAR2(60 BYTE),
  STATE                 VARCHAR2(5 BYTE),
  ZIP                   VARCHAR2(5 BYTE),
  ZIP4                  VARCHAR2(4 BYTE),
  COUNTRY               VARCHAR2(3 BYTE),
  ADT                   VARCHAR2(14 BYTE),
  PFA                   VARCHAR2(25 BYTE),
  PCF                   VARCHAR2(10 BYTE),
  HPN                   VARCHAR2(35 BYTE),
  CPN                   VARCHAR2(25 BYTE),
  WPN                   VARCHAR2(25 BYTE),
  APN                   VARCHAR2(25 BYTE),
  TSTART                VARCHAR2(8 BYTE),
  TEND                  VARCHAR2(8 BYTE),
  PF_NO                 VARCHAR2(6 BYTE),
  PF_NAME               VARCHAR2(80 BYTE),
  VCE                   VARCHAR2(3 BYTE)        NOT NULL,
  SCI                   VARCHAR2(1 BYTE),
  SC_PCT                VARCHAR2(3 BYTE),
  SAI                   VARCHAR2(1 BYTE),
  SALIST                VARCHAR2(25 BYTE),
  NSCI                  VARCHAR2(1 BYTE),
  NLE_ES                VARCHAR2(1 BYTE)        NOT NULL,
  STA_VISN              VARCHAR2(2 BYTE),
  STA_NO                VARCHAR2(6 BYTE),
  STA_NAME              VARCHAR2(75 BYTE),
  EE_FLAG               VARCHAR2(1 BYTE),
  DISTANCE              VARCHAR2(21 BYTE),
  OPP_FLAG              VARCHAR2(1 BYTE),
  ADR_LON               VARCHAR2(20 BYTE),
  ADR_LAT               VARCHAR2(20 BYTE),
  STA_ST1               VARCHAR2(70 BYTE),
  STA_ST2               VARCHAR2(50 BYTE),
  STA_ST3               VARCHAR2(50 BYTE),
  STA_CITY              VARCHAR2(25 BYTE),
  STA_STATE             VARCHAR2(2 BYTE),
  STA_ZIP               VARCHAR2(5 BYTE),
  STA_ZIP4              VARCHAR2(4 BYTE),
  STA_LON               VARCHAR2(20 BYTE),
  STA_LAT               VARCHAR2(20 BYTE),
  LOC_NAME              VARCHAR2(30 BYTE),
  GEO_DATE              VARCHAR2(8 BYTE),
  SOFTWARE_VER          VARCHAR2(50 BYTE),
  STATUS                VARCHAR2(1 BYTE),
  STATUS_DATE           VARCHAR2(1 BYTE),
  WT_INFO_CONCATTED     VARCHAR2(4000 BYTE),
  MAILING_EXCEPTION     VARCHAR2(1 BYTE),
  TIME_COHORT           VARCHAR2(1 BYTE)        NOT NULL,
  BASIC_ELIG            VARCHAR2(1 BYTE)        NOT NULL,
  GEO_TIME_FRAME_BEGIN  VARCHAR2(14 BYTE),
  GEO_TIME_FRAME_END    VARCHAR2(14 BYTE),
  WT_RUN_TIME           VARCHAR2(14 BYTE),
  VBA_DOD               VARCHAR2(8 BYTE),
  EVER_GEO_CODED        VARCHAR2(1 BYTE),
  CALC_TYPE             VARCHAR2(2 BYTE),
  DD_BASIC_ELIG         VARCHAR2(1 BYTE),
  DD_NLE_ES             VARCHAR2(1 BYTE),
  VISN                  VARCHAR2(2 BYTE),
  URH                   VARCHAR2(1 BYTE),
  FIPS                  VARCHAR2(5 BYTE),
  MARKET                VARCHAR2(4 BYTE),
  SUBMARKET             VARCHAR2(6 BYTE),
  SECTOR                VARCHAR2(8 BYTE),
  STATE_FIPS            VARCHAR2(2 BYTE),
  S_CLASS_NAME          VARCHAR2(20 BYTE),
  OUTPATIENTRATING      VARCHAR2(25 BYTE),
  PAR_STA_NO            VARCHAR2(6 BYTE),
  PARENTSTATIONCL       VARCHAR2(80 BYTE),
  SH_PAR_STA            VARCHAR2(6 BYTE),
  VA_SITE               VARCHAR2(1 BYTE),
  ST                    VARCHAR2(2 BYTE),
  POD                   VARCHAR2(1 BYTE),
  SHAR                  VARCHAR2(1 BYTE),
  HCC                   VARCHAR2(1 BYTE),
  MSCBOC                VARCHAR2(1 BYTE),
  NEWVAMC               VARCHAR2(1 BYTE),
  PCCBOC                VARCHAR2(1 BYTE),
  COCCLASSIFICATIONID   VARCHAR2(1 BYTE),
  VAH                   VARCHAR2(1 BYTE),
  CD                    VARCHAR2(20 BYTE),
  CONT                  VARCHAR2(1 BYTE),
  PROV                  VARCHAR2(1 BYTE),
  VACAA_LIST_DATE       VARCHAR2(14 BYTE),
  NLE_ES_DATE           VARCHAR2(14 BYTE),
  COUNTY_NAME           VARCHAR2(50 BYTE),
  MARKET_NAME           VARCHAR2(50 BYTE),
  TPA_LOAD_DATE         VARCHAR2(8 BYTE),
  DATASOURCE            VARCHAR2(10 BYTE),
  DISTRICT              VARCHAR2(2 BYTE),
  STA_DISTRICT_VISN     VARCHAR2(5 BYTE)
)
TABLESPACE L_DATA_01
RESULT_CACHE (MODE DEFAULT)
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
LOGGING 
NOCOMPRESS 
NOCACHE
NOPARALLEL
MONITORING;


CREATE INDEX VETCHOICE.EDIPI_IDX ON VETCHOICE.AGGREGATE_H
(EDIPI)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX VETCHOICE.PERID_IDX ON VETCHOICE.AGGREGATE_H
(PERID)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX VETCHOICE.SSN_IDX ON VETCHOICE.AGGREGATE_H
(SSN)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE INDEX VETCHOICE.TPA_LOAD_DATE_IDX ON VETCHOICE.AGGREGATE_H
(TPA_LOAD_DATE)
LOGGING
TABLESPACE L_INDEX_01
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            MAXSIZE          UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
            FLASH_CACHE      DEFAULT
            CELL_FLASH_CACHE DEFAULT
           )
NOPARALLEL;

CREATE OR REPLACE PUBLIC SYNONYM AGGREGATE_H FOR VETCHOICE.AGGREGATE_H;


GRANT SELECT ON VETCHOICE.AGGREGATE_H TO VETCHOICE_R;

GRANT DELETE, INSERT, SELECT, UPDATE ON VETCHOICE.AGGREGATE_H TO VETCHOICE_RW;
